import { RefObject } from '@mui/x-internals/types';
import { GridAutoGeneratedGroupNode, GridAutoGeneratedPinnedRowNode, GridColDef, GridFooterNode, GridGroupNode, GridRowId, GridRowIdGetter, GridRowModel, GridRowModelUpdate, GridRowTreeConfig, GridSkeletonRowNode, GridTreeNode, GridValidRowModel } from "../../../models/index.js";
import { DataGridProcessedProps } from "../../../models/props/DataGridProps.js";
import { GridApiCommunity, GridPrivateApiCommunity } from "../../../models/api/gridApiCommunity.js";
import { GridRowsInternalCache, GridRowsState, GridRowTreeCreationParams } from "./gridRowsInterfaces.js";
export declare const GRID_ROOT_GROUP_ID: GridRowId;
export declare const GRID_ID_AUTOGENERATED: unique symbol;
export declare const buildRootGroup: () => GridGroupNode;
/**
 * A helper function to check if the id provided is valid.
 * @param {GridRowId} id Id as [[GridRowId]].
 * @param {GridRowModel | Partial<GridRowModel>} row Row as [[GridRowModel]].
 * @param {string} detailErrorMessage A custom error message to display for invalid IDs
 */
export declare function checkGridRowIdIsValid(id: GridRowId, row: GridRowModel | Partial<GridRowModel>, detailErrorMessage?: string): void;
export declare const getRowIdFromRowModel: (rowModel: GridRowModel, getRowId?: GridRowIdGetter, detailErrorMessage?: string) => GridRowId;
export declare const getRowValue: (row: GridValidRowModel, colDef: GridColDef, apiRef: RefObject<GridApiCommunity>) => any;
export declare const createRowsInternalCache: ({
  rows,
  getRowId,
  loading,
  rowCount
}: Pick<DataGridProcessedProps, "rows" | "getRowId" | "loading" | "rowCount">) => GridRowsInternalCache;
export declare const getTopLevelRowCount: ({
  tree,
  rowCountProp
}: {
  tree: GridRowTreeConfig;
  rowCountProp: DataGridProcessedProps["rowCount"];
}) => number;
export declare const getRowsStateFromCache: ({
  apiRef,
  rowCountProp,
  loadingProp,
  previousTree,
  previousTreeDepths,
  previousGroupsToFetch
}: Pick<GridRowTreeCreationParams, "previousTree" | "previousTreeDepths" | "previousGroupsToFetch"> & {
  apiRef: RefObject<GridPrivateApiCommunity>;
  rowCountProp: number | undefined;
  loadingProp: boolean | undefined;
}) => GridRowsState;
export declare const isAutogeneratedRow: (row: GridRowModel) => boolean;
export declare const isAutogeneratedRowNode: (rowNode: GridTreeNode) => rowNode is GridFooterNode | GridSkeletonRowNode | GridAutoGeneratedGroupNode | GridAutoGeneratedPinnedRowNode;
export declare const getTreeNodeDescendants: (tree: GridRowTreeConfig, parentId: GridRowId, skipAutoGeneratedRows: boolean) => GridRowId[];
export declare const updateCacheWithNewRows: ({
  previousCache,
  getRowId,
  updates,
  groupKeys
}: {
  previousCache: GridRowsInternalCache;
  getRowId: DataGridProcessedProps["getRowId"];
  updates: GridRowModelUpdate[];
  groupKeys?: string[];
}) => GridRowsInternalCache;
export declare const minimalContentHeight = "var(--DataGrid-overlayHeight, calc(var(--height) * 2))";
export declare function computeRowsUpdates(apiRef: RefObject<GridApiCommunity>, updates: GridRowModelUpdate[], getRowId: DataGridProcessedProps['getRowId']): GridRowModelUpdate[];
export declare const getValidRowHeight: (rowHeightProp: any, defaultRowHeight: number, warningMessage: string) => number;
export declare const rowHeightWarning: string;
export declare const getRowHeightWarning: string;